/*
	Tagrecommender based on Factorization Machines using binary user, item, tag indicators.

	Based on the publication(s):
	Steffen Rendle (2010): Factorization Machines, in Proceedings of the 10th IEEE International Conference on Data Mining (ICDM 2010), Sydney, Australia.

	Notes:
	Abstract class for factorization machine based tag recommender. There are two examples how to integrate FMs: 
	one using the generic functionality of the FM library and one with integrated prediction and gradient steps.
	Both do exactly the same, the first one is easier to implement, the second one faster.


	Author:   Steffen Rendle, http://www.libfm.org/
	modified: 2011-07-14

	Copyright 2011 Steffen Rendle, see license.txt for more information
*/

#ifndef TAGRECOMMENDERFACTORIZATIONMACHINE_H_
#define TAGRECOMMENDERFACTORIZATIONMACHINE_H_

#include "../../fm_core/fm_data.h"
#include "../../fm_core/fm_model.h"
#include "../../fm_core/fm_sgd.h"



class TagRecommenderFactorizationMachine : public TagRecommender {
	public:
		int num_iterations;
		int num_neg_samples;
		double learn_rate;
		
		Dataset* ds;
		
		fm_model fm;

		int num_user;
		int num_item;
		int num_tag;

		virtual void init() {};	

		virtual void train(Dataset& dataset) {
			TagLearnerBPR learner;
			learner.num_iterations = this->num_iterations;
			learner.num_neg_samples = this->num_neg_samples;
			learner.train(dataset, *this);
		}
					
};

#endif /*TAGRECOMMENDERFACTORIZATIONMACHINE_H_*/
